/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.impl.task;

import dev.engine_room.flywheel.impl.FlwConfig;
import dev.engine_room.flywheel.impl.task.ParallelTaskExecutor;
import dev.engine_room.flywheel.impl.task.SerialTaskExecutor;
import dev.engine_room.flywheel.impl.task.TaskExecutorImpl;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_3532;

public final class FlwTaskExecutor {
    private static final AtomicLazy INSTANCE = new AtomicLazy();

    private FlwTaskExecutor() {
    }

    public static TaskExecutorImpl get() {
        return INSTANCE.get();
    }

    private static int getOptimalThreadCount() {
        return class_3532.method_15340((int)Math.max(FlwTaskExecutor.getMaxThreadCount() / 3, FlwTaskExecutor.getMaxThreadCount() - 6), (int)1, (int)10);
    }

    private static int getMaxThreadCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    private static class AtomicLazy {
        private final AtomicReference<AtomicLazy> factory = new AtomicReference();
        private final AtomicReference<TaskExecutorImpl> reference = new AtomicReference();

        private AtomicLazy() {
        }

        public final TaskExecutorImpl get() {
            TaskExecutorImpl result;
            while ((result = this.reference.get()) == null) {
                if (!this.factory.compareAndSet(null, this)) continue;
                this.reference.set(this.initialize());
            }
            return result;
        }

        protected TaskExecutorImpl initialize() {
            int threadCount = FlwConfig.INSTANCE.workerThreads();
            if (threadCount == 0) {
                return SerialTaskExecutor.INSTANCE;
            }
            threadCount = threadCount < 0 ? FlwTaskExecutor.getOptimalThreadCount() : class_3532.method_15340((int)threadCount, (int)1, (int)FlwTaskExecutor.getMaxThreadCount());
            ParallelTaskExecutor executor = new ParallelTaskExecutor("Flywheel", threadCount);
            executor.startWorkers();
            return executor;
        }
    }
}

